#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sun Dec  3 19:33:21 2023

@author: anton
"""
from SLiCAP import trace, plot, float2rational
from numpy import geomspace
from sympy import Symbol, lambdify, sqrt
# Create DIN A correction curve
# https://en.wikipedia.org/wiki/A-weighting
f            = Symbol("f", positive=True)
DinA         = 12194**2*f**4/((f**2+20.6**2)*(f**2+12194**2)*sqrt((f**2+107.7**2)*(f**2+737.9**2)))

# normalized the weighting function w.r.t. 1kHz
DinA         = float2rational(DinA/DinA.subs(f,1000))

# Plot the DIN A weighting curve
x            = geomspace(20, 20000, num=200)
y            = lambdify(f,DinA)
tr           = trace([x, y(x)])
tr.label     = "DIN A"
DINA_plot    = plot("DINA", "DIN A normalized at 1kHz", 'log', {"DINA":tr}, xName='frequency', xUnits='Hz', yName='Weight', show=True)
