#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Dec 15 23:12:29 2023

@author: anton
"""

from SLiCAP import *
import numpy as np
import sympy as sp
from scipy.integrate import quad
from DIN_A import DinA, DINA_plot

print("\n**********************************************************************")
print("* Create initial specifications                                      *")
print("* and determine noise contribution of the signal source              *")
print("**********************************************************************\n")

# Import the specifications
initSpecs = csv2specs('A1specs.csv')

cir = makeCircuit("kicad/noise1/noise1.kicad_sch")
# Load circuit parameters from specifications
specs2circuit(initSpecs, cir)
noiseResult1 = doNoise(cir, pardefs="circuit")

f_min           = cir.getParValue('f_min')
f_max           = cir.getParValue('f_max')
V_noise         = cir.getParValue('V_onoise')
N_var_required  = V_noise**2
S_onoise        = noiseResult1.onoise

f               = ini.frequency
func_OnoiseVar  = sp.lambdify(f, sp.N(S_onoise * DinA**2))
N_var_1_dinA    = quad(func_OnoiseVar, f_min, f_max)[0]
RMS_1           = np.sqrt(N_var_1_dinA)

n_SRC           = N_var_1_dinA/N_var_required

print("\nThe relative contribution of the source noise to the squared DIN-A " +
      "weighted RMS output noise amounts %s."%(str(sp.N(n_SRC, 3))))

updatedSpecs = [spec for spec in initSpecs]

updatedSpecs.append(
        specItem('SRCnoise',
        description = "DIN A weighted RMS output noise, source + termination",
        value       = RMS_1,
        units       = "V",
        specType    = "design",
        )
)

updatedSpecs.append(
        specItem('n_SRC',
        description = "Relative contribution of source noise to the squared " +
                      "DIN-A weighted RMS output noise",
        value       = n_SRC,
        units       = "",
        specType    = "budgets",
        )
)

specs2csv(updatedSpecs, 'A1specs.csv')

###############################################################################
# HTML Report
###############################################################################
htmlPage('Specifications')
head2html('Initial specifications')
text2html('The initial noise specifications are summerized in the table below.')
specs2html(initSpecs)
head2html('Updated specifications')
text2html('After finishing this design step the updated specifications are:')
specs2html(updatedSpecs)

htmlPage('DIN A weighting curve')
text2html('The expression for the DIN A weighting of the noise voltage is:')
eqn2html('DIN_A', DinA)
text2html('The frequency plot is shown below.')
fig2html(DINA_plot, 600)

htmlPage("Source noise budget")
text2html("The total budget for the squared output noise is $%s$ $\\left[ \\mathrm{V^2} \\right]$."%(sp.latex(sp.N(N_var_required, 2))))
text2html("The contribution of the terminated source to this is $%s$ $\\left[ \\mathrm{V^2} \\right]$."%(sp.latex(sp.N(N_var_1_dinA, 2))))
text2html("This is $%s$ percent of the total budget."%(sp.latex(sp.N(100*N_var_1_dinA/N_var_required, 2))))