#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Dec 15 23:12:29 2023

@author: anton
"""

from SLiCAP import *
import sympy as sp
import numpy as np
from scipy.integrate import quad
from DIN_A import DinA

print("\n**********************************************************************")
print("* 1. Assign budget for noise of the integration resistor             *")
print("* 2. Calculate the maximum value of R_i                              *")
print("* 3. Select a value of R_i                                           *")
print("* 4. Calculate feedback network drive requirements.                  *")
print("**********************************************************************\n")
# Import the specifications
initSpecs = csv2specs('A1specs.csv')


cir = makeCircuit("kicad/noise2/noise2.kicad_sch")
# Load circuit parameters from specifications
specs2circuit(initSpecs, cir)

R_i                 = sp.Symbol("R_i")
f_min               = cir.getParValue('f_min')
f_max               = cir.getParValue('f_max')
V_noise             = cir.getParValue('V_onoise')
tau_i               = cir.getParValue('tau_i')
f_fp                = cir.getParValue('f_fp')
Vi_ADC              = cir.getParValue('Vi_ADC')
n_SRC               = cir.getParValue('n_SRC')
SRCnoise            = cir.getParValue('SRCnoise')

noiseResult2 = doNoise(cir, pardefs="circuit")
S_onoise     = noiseResult2.onoise

n_Ri = 0

while n_Ri > 1 - n_SRC or n_Ri <= 0:
    try:
        n_Ri = float(input("\nPlease assign a budget for the relative contribution of " +
                           "the noise of the integrator resistance to the "+
                           "squared DIN-A weighted RMS output noise " +
                           "(> 0 and < %s):\n>>> "%(sp.N(1-n_SRC,3))))
    except ValueError:
        n_Ri = 0

N_var_required  = V_noise**2 * (n_Ri + n_SRC)
