#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sun Dec  3 19:21:40 2023

@author: anton
"""

from SLiCAP import specItem, specs2csv
# Define gain and noise spec for the receive coil amplifier

tau_i           = 16E-6    # A1 integration time constant
f_min           = 300      # Low 3dB cut off frequency
f_max           = 6000     # High 3dB cut-off frequency
f_ref           = 1000     # Reference frequency for receive coil sensitivity
f_fp            = 5000     # Max. full-power frequency
Vi_ADC          = 0.9      # Peak-peak input voltage ADC
SPLref          = 20E-6    # 0dB SPL level in Pa
mic_dB_Pa       = -34.5    # microphone sensitivity in dBV/Pa
SPL_noise       = 30       # Allowed SPL noise level
SPL_max         = 110      # Max sound pressure level
SPL_ref         = 90       # dB/(A/m) inductive loop reference
SPL_sens        = -59.4    # dBV/(A/m) receive coil sensitivity at f_ref
V_noise         = 20E-6 * 10**((mic_dB_Pa + SPL_noise)/20)
Rs              = 875      # Source reistance
Ls              = 0.12     # Source inductance
F_crest         = 3        # Signal crest factor
Vi_pp           = 2 * F_crest * 10**((SPL_sens + SPL_max - SPL_ref)/20)*f_fp/f_ref
specs = []

# source electrical specification

specs.append(
    specItem(
        "L_s",
        description = "Source inductance",
        value       = Ls,
        units       = "H",
        specType    = "performance",
    )
)
specs.append(
    specItem(
        "R_s",
        description = "Source resistance",
        value       = Rs,
        units       = "Omega",
        specType    = "performance",
    )
)

specs.append(
    specItem(
        "R_t",
        description = "Termination resistance",
        value       = Ls/tau_i,
        units       = "H",
        specType    = "performance",
    )
)

# source signal specification

specs.append(
    specItem(
        "Vi_pp",
        description = "Maximum peak-peak input voltage",
        value       = Vi_pp,
        units       = "",
        specType    = "performance",
    )
)

specs.append(
    specItem(
        "f_fp",
        description = "Maximum full-power frequency",
        value       = f_fp,
        units       = "Hz",
        specType    = "performance",
    )
)

# Performance requirements (Range, Bandwidth, Resolution)

specs.append(
    specItem(
        "tau_i",
        description = "Integration time constant",
        value       = tau_i,
        units       = "s",
        specType    = "performance",
    )
)

specs.append(
    specItem(
        "f_min",
        description = "-3dB high-pass cut-off frequency",
        value       = f_min,
        units       = "Hz",
        specType    = "performance",
    )
)

specs.append(
    specItem(
        "f_max",
        description = "-3dB low-pass cut-off frequency",
        value       = f_max,
        units       = "Hz",
        specType    = "performance",
    )
)

specs.append(
    specItem(
        "V_onoise",
        description = "DIN A weighted output voltage noise",
        value       = V_noise,
        units       = "V",
        specType    = "performance",
    )
)

specs.append(
    specItem(
        "Vi_ADC",
        description = "Peak-peak input voltage ADC",
        value       = Vi_ADC,
        units       = "V",
        specType    = "performance",
    )
)

specs2csv(specs, 'A1specs.csv')