#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Apr 19 13:02:51 2025

@author: anton
"""
import SLiCAP as sl
from SLiCAPmosNoise import process, specObject, doMOSnoiseDesign

sl.initProject("MOSdesign")

# Circuit specification
kicad_sch = "kicad/Trimp/Trimp.kicad_sch"

# Noise specifications
specs = specObject()
specs.noiseRMS = 100e-6  # Total RMS output noise budget over frequency range
specs.f_min    = 1       # Lower limit of frequency range
specs.f_max    = 1e6     # Upper limit of frequency range
specs.ID_spec  = 1e-3    # Current budget; always positive, also for P-channel
specs.IC       = None    # IC for noise design according to specs
specs.IC_max   = 15      # IC for minimum noise (maximum fT)
specs.gmID     = 10      # gmID for noise design according to specs
                         # will be overruled by specs.IC
specs.gmID_min = None    # gmID for minimum noise (maximum fT)
                         # will be overruled by specs.IC_max

# Technology specifications
models = []

model         = process()
model.name    = "MN18_noisyNullor"
model.channel = "N"
model.IG      = 0
model.L_min   = 0.18e-6
model.L_max   = 50e-6
model.W_min   = 0.18e-6
model.W_max   = 10e-3

models.append(model)

model         = process()
model.name    = "MP18_noisyNullor" 
model.channel = "P"
model.IG      = 0
model.L_min   = 0.18e-6
model.L_max   = 50e-6
model.W_min   = 0.18e-6
model.W_max   = 10e-3

models.append(model)

# Noise design without iteration
all_results = doMOSnoiseDesign(kicad_sch, specs, models, printAll=True)